# Move Carsharing (PHP + SQLite) — MVP Marketplace

## Requisitos
- PHP 8.0+ (funciona en hosting tipo cPanel)
- Extensión PDO_SQLITE habilitada
- Permisos de escritura en:
  - /data
  - /public/uploads

## Instalación (cPanel típico)
1) Subí el contenido del ZIP a tu public_html (o a una carpeta).
2) Verificá permisos:
   - data/ (775 o 777 según hosting)
   - public/uploads/ (775 o 777)
3) Abrí la web. La base SQLite se crea automáticamente en `data/app.sqlite` si no existe.

## Accesos por defecto
- Admin:
  - Email: admin@movecarsharing.com
  - Password: Admin123!
  - **Cambialo apenas entres** (en producción, cambiá el hash en DB o implementá pantalla de cambio).

## Notas MVP
- Fee (service fee): 20% (se suma al total del cliente).
- Booking mode por auto:
  - Instant: reserva queda `pending_payment` hasta pago
  - Request: queda `requested`, el dueño aprueba y pasa a `pending_payment`
- Pagos:
  - Transferencia bancaria: el cliente carga referencia y queda `pending`. Admin confirma y pasa a `paid`.
  - dLocal: está preparado el modelo (payments.method='dlocal'), falta integrar API/webhooks.

## Seguridad básica incluida
- Password hashing (password_hash / verify)
- CSRF tokens
- Validación de subida de imágenes (mime/extensión)
- Escape de salida HTML

## Estructura
- public/ : archivos web
- app/    : lógica (DB, auth, helpers)
- data/   : SQLite

