<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';

function current_user(): ?array {
  return $_SESSION['user'] ?? null;
}

function login_user(array $u): void {
  $_SESSION['user'] = [
    'id' => (int)$u['id'],
    'role' => $u['role'],
    'name' => $u['name'],
    'email' => $u['email'],
  ];
}

function logout_user(): void {
  unset($_SESSION['user']);
  session_regenerate_id(true);
}

function require_login(): void {
  if (!current_user()) redirect('login.php');
}

function require_role(string $role): void {
  require_login();
  if (current_user()['role'] !== $role) {
    http_response_code(403);
    exit('Forbidden');
  }
}

function require_any_role(array $roles): void {
  require_login();
  if (!in_array(current_user()['role'], $roles, true)) {
    http_response_code(403);
    exit('Forbidden');
  }
}
