<?php
declare(strict_types=1);
require_once __DIR__ . '/db.php';

function car_is_available(int $carId, string $start, string $end): bool {
  $pdo = db();

  // blocks
  $q1 = $pdo->prepare("
    SELECT COUNT(*) AS c
    FROM car_blocks
    WHERE car_id = :car_id
      AND NOT (:end_date < start_date OR :start_date > end_date)
  ");
  $q1->execute([':car_id' => $carId, ':start_date' => $start, ':end_date' => $end]);
  if ((int)$q1->fetch()['c'] > 0) return false;

  // bookings
  $q2 = $pdo->prepare("
    SELECT COUNT(*) AS c
    FROM bookings
    WHERE car_id = :car_id
      AND status IN ('approved','pending_payment','paid')
      AND NOT (:end_date < start_date OR :start_date > end_date)
  ");
  $q2->execute([':car_id' => $carId, ':start_date' => $start, ':end_date' => $end]);
  return ((int)$q2->fetch()['c']) === 0;
}
