<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/availability.php';
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/helpers.php';

require_login();
csrf_verify();

$carId = (int)($_POST['car_id'] ?? 0);
$start = trim($_POST['start'] ?? '');
$end = trim($_POST['end'] ?? '');

if (!$carId || !$start || !$end) { flash_set('err','Datos incompletos.'); redirect('search.php'); }

$ds = parse_date($start);
$de = parse_date($end);
if (!$ds || !$de || $de < $ds) { flash_set('err','Fechas inválidas.'); redirect('car.php?id='.$carId); }

$pdo = db();
$c = $pdo->prepare("SELECT * FROM cars WHERE id=? AND status='active'");
$c->execute([$carId]);
$car = $c->fetch();
if (!$car) { flash_set('err','Auto no encontrado.'); redirect('search.php'); }

if (!car_is_available($carId, $start, $end)) {
  flash_set('err','Ese auto no está disponible para esas fechas.');
  redirect('car.php?id='.$carId.'&start='.$start.'&end='.$end);
}

$days = days_between_inclusive($start, $end);
$subtotal = $days * (int)$car['price_per_day'];
$service_fee = (int)round($subtotal * SERVICE_FEE_RATE);
$total = $subtotal + $service_fee;

$status = ($car['booking_mode'] === 'instant') ? 'pending_payment' : 'requested';

$ins = $pdo->prepare("INSERT INTO bookings (car_id, renter_id, start_date, end_date, days, subtotal, service_fee, total, status)
                      VALUES (?,?,?,?,?,?,?,?,?)");
$ins->execute([$carId, current_user()['id'], $start, $end, $days, $subtotal, $service_fee, $total, $status]);
$bookingId = (int)$pdo->lastInsertId();

if ($status === 'requested') {
  flash_set('ok','Solicitud enviada. Esperá la aprobación del dueño.');
  redirect('dashboard_user.php');
}

flash_set('ok','Reserva creada. Quedó pendiente hasta que abones.');
redirect('booking_pay.php?id=' . $bookingId);
