<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/csrf.php';
require_once __DIR__ . '/../app/helpers.php';

require_any_role(['owner','admin']); // admin can view too
$pdo = db();
$uid = current_user()['id'];
$isAdmin = current_user()['role']==='admin';

if ($_SERVER['REQUEST_METHOD']==='POST') {
  csrf_verify();
  $action = $_POST['action'] ?? '';
  if ($action === 'create_car') {
    $title = trim($_POST['title'] ?? '');
    $make = trim($_POST['make'] ?? '');
    $model = trim($_POST['model'] ?? '');
    $year = (int)($_POST['year'] ?? 0);
    $trans = trim($_POST['transmission'] ?? '');
    $seats = (int)($_POST['seats'] ?? 0);
    $city = trim($_POST['city'] ?? '');
    $pickup = trim($_POST['pickup_address'] ?? '');
    $price = (int)($_POST['price_per_day'] ?? 0);
    $deposit = (int)($_POST['deposit'] ?? 0);
    $mode = ($_POST['booking_mode'] ?? 'instant');
    $rules = trim($_POST['rules'] ?? '');

    if ($title==='' || $price<=0) { flash_set('err','Completá título y precio por día.'); redirect('dashboard_owner.php'); }
    if (!in_array($mode,['instant','request'],true)) $mode='instant';

    $ins = $pdo->prepare("INSERT INTO cars (owner_id, status, title, make, model, year, transmission, seats, city, pickup_address, price_per_day, deposit, booking_mode, rules)
                          VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $ins->execute([$uid, 'pending', $title, $make, $model, $year?:null, $trans, $seats?:null, $city, $pickup, $price, $deposit, $mode, $rules]);
    $carId = (int)$pdo->lastInsertId();

    // Photos upload (multiple)
    if (!empty($_FILES['photos']) && is_array($_FILES['photos']['name'])) {
      $count = min(count($_FILES['photos']['name']), 8);
      for ($i=0; $i<$count; $i++) {
        if ($_FILES['photos']['error'][$i] !== UPLOAD_ERR_OK) continue;
        $tmp = $_FILES['photos']['tmp_name'][$i];
        $name = $_FILES['photos']['name'][$i];
        $size = (int)$_FILES['photos']['size'][$i];

        if ($size > 5*1024*1024) continue; // 5MB
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mime = finfo_file($finfo, $tmp);
        finfo_close($finfo);

        $allowed = ['image/jpeg'=>'jpg','image/png'=>'png','image/webp'=>'webp'];
        if (!isset($allowed[$mime])) continue;

        if (!is_dir(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0775, true);
        $safe = bin2hex(random_bytes(8)) . '.' . $allowed[$mime];
        $dest = UPLOAD_DIR . '/' . $safe;
        if (move_uploaded_file($tmp, $dest)) {
          $path = 'uploads/' . $safe;
          $p = $pdo->prepare("INSERT INTO car_photos (car_id, path, sort_order) VALUES (?,?,?)");
          $p->execute([$carId, $path, $i]);
        }
      }
    }

    flash_set('ok','Auto creado y enviado a revisión. Un admin debe activarlo.');
    redirect('dashboard_owner.php');
  }

  if ($action === 'booking_decision') {
    $bookingId = (int)($_POST['booking_id'] ?? 0);
    $decision = $_POST['decision'] ?? '';
    if (!$bookingId || !in_array($decision,['approve','reject'],true)) redirect('dashboard_owner.php');

    // ensure booking belongs to owner's car (unless admin)
    $q = $pdo->prepare("SELECT b.*, c.owner_id FROM bookings b JOIN cars c ON c.id=b.car_id WHERE b.id=?");
    $q->execute([$bookingId]);
    $b = $q->fetch();
    if (!$b) redirect('dashboard_owner.php');
    if (!$isAdmin && (int)$b['owner_id'] !== $uid) { http_response_code(403); exit('Forbidden'); }
    if ($b['status'] !== 'requested') { flash_set('err','La reserva no está en estado requested.'); redirect('dashboard_owner.php'); }

    if ($decision==='approve') {
      $pdo->prepare("UPDATE bookings SET status='pending_payment' WHERE id=?")->execute([$bookingId]);
      flash_set('ok','Reserva aprobada. Queda pendiente de pago.');
    } else {
      $pdo->prepare("UPDATE bookings SET status='rejected' WHERE id=?")->execute([$bookingId]);
      flash_set('ok','Reserva rechazada.');
    }
    redirect('dashboard_owner.php');
  }
}

// Cars list
$carsStmt = $pdo->prepare("SELECT * FROM cars WHERE owner_id=? ORDER BY created_at DESC");
$carsStmt->execute([$uid]);
$cars = $carsStmt->fetchAll();

// Incoming bookings
$bookStmt = $pdo->prepare("SELECT b.*, c.title as car_title
                           FROM bookings b JOIN cars c ON c.id=b.car_id
                           WHERE c.owner_id=?
                           ORDER BY b.created_at DESC LIMIT 50");
$bookStmt->execute([$uid]);
$bookings = $bookStmt->fetchAll();

require_once __DIR__ . '/_layout_top.php';
?>
<div class="max-w-6xl mx-auto space-y-6">
  <div class="flex items-end justify-between gap-3">
    <div>
      <h2 class="text-2xl font-semibold">Panel de dueño</h2>
      <div class="text-slate-600">Publicá autos y gestioná solicitudes. (Instant o Aprobación)</div>
    </div>
  </div>

  <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    <div class="rounded-3xl border border-slate-200 bg-white p-6">
      <h3 class="text-lg font-semibold">Publicar auto</h3>
      <p class="text-sm text-slate-600 mt-1">Queda <b>pendiente</b> hasta aprobación admin.</p>

      <form method="post" enctype="multipart/form-data" class="mt-5 space-y-3">
        <?= csrf_input() ?>
        <input type="hidden" name="action" value="create_car">
        <div>
          <label class="text-xs text-slate-500">Título</label>
          <input name="title" class="mt-1 w-full rounded-xl border-slate-200" placeholder="Ej: Fiat Cronos 2022 - Full" required>
        </div>
        <div class="grid grid-cols-2 gap-2">
          <div><label class="text-xs text-slate-500">Marca</label><input name="make" class="mt-1 w-full rounded-xl border-slate-200"></div>
          <div><label class="text-xs text-slate-500">Modelo</label><input name="model" class="mt-1 w-full rounded-xl border-slate-200"></div>
        </div>
        <div class="grid grid-cols-3 gap-2">
          <div><label class="text-xs text-slate-500">Año</label><input type="number" name="year" class="mt-1 w-full rounded-xl border-slate-200"></div>
          <div><label class="text-xs text-slate-500">Asientos</label><input type="number" name="seats" class="mt-1 w-full rounded-xl border-slate-200"></div>
          <div><label class="text-xs text-slate-500">Transmisión</label>
            <select name="transmission" class="mt-1 w-full rounded-xl border-slate-200">
              <option value="">—</option><option>Manual</option><option>Automática</option>
            </select>
          </div>
        </div>
        <div><label class="text-xs text-slate-500">Ciudad</label><input name="city" class="mt-1 w-full rounded-xl border-slate-200" placeholder="Ej: CABA"></div>
        <div><label class="text-xs text-slate-500">Dirección punto fijo</label><input name="pickup_address" class="mt-1 w-full rounded-xl border-slate-200" placeholder="Ej: Av. Corrientes 800, CABA"></div>
        <div class="grid grid-cols-2 gap-2">
          <div><label class="text-xs text-slate-500">Precio por día (ARS)</label><input type="number" name="price_per_day" class="mt-1 w-full rounded-xl border-slate-200" required></div>
          <div><label class="text-xs text-slate-500">Depósito/garantía (ARS)</label><input type="number" name="deposit" class="mt-1 w-full rounded-xl border-slate-200" value="0"></div>
        </div>
        <div>
          <label class="text-xs text-slate-500">Modo de reserva</label>
          <select name="booking_mode" class="mt-1 w-full rounded-xl border-slate-200">
            <option value="instant">Instant (queda pendiente hasta pago)</option>
            <option value="request">Aprobación (solicitud)</option>
          </select>
        </div>
        <div>
          <label class="text-xs text-slate-500">Reglas</label>
          <textarea name="rules" rows="3" class="mt-1 w-full rounded-xl border-slate-200" placeholder="Ej: No fumar, devolver con mismo nivel de combustible..."></textarea>
        </div>
        <div>
          <label class="text-xs text-slate-500">Fotos (hasta 8)</label>
          <input type="file" name="photos[]" multiple accept="image/*" class="mt-1 w-full">
        </div>
        <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 hover:bg-slate-800">Publicar</button>
      </form>
    </div>

    <div class="rounded-3xl border border-slate-200 bg-white p-6">
      <h3 class="text-lg font-semibold">Solicitudes y reservas</h3>
      <div class="mt-4 space-y-3">
        <?php foreach ($bookings as $b): ?>
          <div class="rounded-2xl border border-slate-200 p-4">
            <div class="flex items-start justify-between gap-3">
              <div>
                <div class="font-semibold"><?= e($b['car_title']) ?> <span class="text-slate-400 font-normal">#<?= (int)$b['id'] ?></span></div>
                <div class="text-sm text-slate-600"><?= e($b['start_date']) ?> → <?= e($b['end_date']) ?> (<?= (int)$b['days'] ?> días)</div>
                <div class="text-sm mt-1">Total: <span class="font-semibold"><?= money((int)$b['total']) ?></span></div>
              </div>
              <span class="text-xs px-2 py-1 rounded-full
                <?= $b['status']==='paid'?'bg-emerald-50 text-emerald-700':
                    ($b['status']==='pending_payment'?'bg-slate-100 text-slate-700':
                    ($b['status']==='requested'?'bg-amber-50 text-amber-700':
                    ($b['status']==='rejected'?'bg-rose-50 text-rose-700':'bg-slate-100 text-slate-700'))) ?>">
                <?= e($b['status']) ?>
              </span>
            </div>

            <?php if ($b['status']==='requested'): ?>
              <form method="post" class="mt-3 flex gap-2">
                <?= csrf_input() ?>
                <input type="hidden" name="action" value="booking_decision">
                <input type="hidden" name="booking_id" value="<?= (int)$b['id'] ?>">
                <button name="decision" value="approve" class="px-3 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800 text-sm">Aprobar</button>
                <button name="decision" value="reject" class="px-3 py-2 rounded-xl border border-slate-200 hover:bg-slate-50 text-sm">Rechazar</button>
              </form>
            <?php else: ?>
              <div class="mt-3 text-xs text-slate-500">Instant y aprobadas pasan a pendiente de pago. Pagadas quedan confirmadas.</div>
            <?php endif; ?>
          </div>
        <?php endforeach; ?>
        <?php if (!$bookings): ?>
          <div class="text-sm text-slate-500">Todavía no tenés reservas.</div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <h3 class="text-lg font-semibold">Mis autos</h3>
    <div class="mt-3 grid grid-cols-1 md:grid-cols-3 gap-4">
      <?php foreach ($cars as $c): ?>
        <div class="rounded-2xl border border-slate-200 p-4">
          <div class="font-semibold"><?= e($c['title']) ?></div>
          <div class="text-sm text-slate-600 mt-1"><?= e($c['city'] ?? '') ?> · <?= money((int)$c['price_per_day']) ?>/día</div>
          <div class="mt-2 text-xs">
            <span class="px-2 py-1 rounded-full <?= $c['status']==='active'?'bg-emerald-50 text-emerald-700':'bg-amber-50 text-amber-700' ?>">
              <?= e($c['status']) ?>
            </span>
            <span class="ml-2 px-2 py-1 rounded-full <?= $c['booking_mode']==='instant'?'bg-slate-100 text-slate-700':'bg-slate-100 text-slate-700' ?>">
              <?= $c['booking_mode']==='instant'?'instant':'request' ?>
            </span>
          </div>
        </div>
      <?php endforeach; ?>
      <?php if (!$cars): ?>
        <div class="text-sm text-slate-500">Todavía no publicaste autos.</div>
      <?php endif; ?>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
