<?php
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/helpers.php';

require_login();
$pdo = db();

$stmt = $pdo->prepare("SELECT b.*, c.title as car_title
                       FROM bookings b JOIN cars c ON c.id=b.car_id
                       WHERE b.renter_id=?
                       ORDER BY b.created_at DESC LIMIT 50");
$stmt->execute([current_user()['id']]);
$rows = $stmt->fetchAll();

require_once __DIR__ . '/_layout_top.php';
?>
<div class="max-w-5xl mx-auto">
  <div class="flex items-end justify-between gap-3 mb-4">
    <div>
      <h2 class="text-2xl font-semibold">Mis reservas</h2>
      <div class="text-slate-600">Hola, <?= e(current_user()['name']) ?>.</div>
    </div>
    <a href="search.php" class="px-4 py-2 rounded-xl border border-slate-200 hover:bg-slate-50">Buscar autos</a>
  </div>

  <div class="rounded-3xl border border-slate-200 bg-white overflow-hidden">
    <div class="overflow-x-auto">
      <table class="w-full text-sm">
        <thead class="bg-slate-50 text-slate-600">
          <tr>
            <th class="text-left p-3">Reserva</th>
            <th class="text-left p-3">Auto</th>
            <th class="text-left p-3">Fechas</th>
            <th class="text-left p-3">Total</th>
            <th class="text-left p-3">Estado</th>
            <th class="text-right p-3">Acción</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach ($rows as $b): ?>
          <tr class="border-t border-slate-200">
            <td class="p-3 font-mono">#<?= (int)$b['id'] ?></td>
            <td class="p-3"><?= e($b['car_title']) ?></td>
            <td class="p-3"><?= e($b['start_date']) ?> → <?= e($b['end_date']) ?></td>
            <td class="p-3 font-semibold"><?= money((int)$b['total']) ?></td>
            <td class="p-3">
              <span class="px-2 py-1 rounded-full text-xs
                <?= $b['status']==='paid'?'bg-emerald-50 text-emerald-700':
                    ($b['status']==='pending_payment'?'bg-slate-100 text-slate-700':
                    ($b['status']==='requested'?'bg-amber-50 text-amber-700':
                    ($b['status']==='rejected'?'bg-rose-50 text-rose-700':'bg-slate-100 text-slate-700'))) ?>">
                <?= e($b['status']) ?>
              </span>
            </td>
            <td class="p-3 text-right">
              <?php if ($b['status']==='pending_payment'): ?>
                <a class="px-3 py-1.5 rounded-xl bg-slate-900 text-white hover:bg-slate-800" href="booking_pay.php?id=<?= (int)$b['id'] ?>">Pagar</a>
              <?php else: ?>
                <span class="text-slate-400">—</span>
              <?php endif; ?>
            </td>
          </tr>
          <?php endforeach; ?>
          <?php if (!$rows): ?>
          <tr><td class="p-4 text-slate-500" colspan="6">Todavía no tenés reservas.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
