<?php require_once __DIR__ . '/_layout_top.php'; ?>
<section class="relative overflow-hidden rounded-3xl border border-slate-200 bg-white">
  <div class="absolute inset-0 bg-gradient-to-br from-slate-900/5 via-white to-slate-900/5"></div>
  <div class="relative p-8 md:p-12">
    <div class="max-w-2xl">
      <h1 class="text-3xl md:text-5xl font-semibold tracking-tight">Alquilá autos de particulares, simple y seguro.</h1>
      <p class="mt-3 text-slate-600 text-lg">Move Carsharing conecta dueños y conductores en un marketplace tipo Airbnb. Reservas con aprobación o instantáneas. Punto fijo de entrega.</p>
    </div>

    <form action="search.php" method="get" class="mt-8 grid grid-cols-1 md:grid-cols-4 gap-3 bg-white/80 rounded-2xl p-4 border border-slate-200">
      <div>
        <label class="text-xs text-slate-500">Ciudad</label>
        <input name="city" placeholder="Ej: CABA" class="mt-1 w-full rounded-xl border-slate-200 focus:border-slate-400 focus:ring-0" />
      </div>
      <div>
        <label class="text-xs text-slate-500">Desde</label>
        <input type="date" name="start" class="mt-1 w-full rounded-xl border-slate-200 focus:border-slate-400 focus:ring-0" />
      </div>
      <div>
        <label class="text-xs text-slate-500">Hasta</label>
        <input type="date" name="end" class="mt-1 w-full rounded-xl border-slate-200 focus:border-slate-400 focus:ring-0" />
      </div>
      <div class="flex items-end">
        <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 hover:bg-slate-800">Buscar</button>
      </div>
    </form>

    <div id="como" class="mt-10 grid grid-cols-1 md:grid-cols-3 gap-4">
      <div class="rounded-2xl border border-slate-200 bg-white p-5">
        <div class="font-semibold">1) Elegí un auto</div>
        <div class="text-sm text-slate-600 mt-1">Buscá por ciudad y fechas. Mirá precio, reglas y punto de entrega.</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-5">
        <div class="font-semibold">2) Reservá</div>
        <div class="text-sm text-slate-600 mt-1">Instantáneo o “solicitar y aprobar”. La reserva queda pendiente hasta pagar.</div>
      </div>
      <div class="rounded-2xl border border-slate-200 bg-white p-5">
        <div class="font-semibold">3) Retiro y devolución</div>
        <div class="text-sm text-slate-600 mt-1">Coordinás por chat. Punto fijo, checklist y fotos (V2).</div>
      </div>
    </div>
  </div>
</section>

<section class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-4">
  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <div class="text-lg font-semibold">¿Tenés un auto?</div>
    <p class="text-slate-600 mt-1">Publicalo y elegí si querés aprobar reservas o confirmarlas automáticamente.</p>
    <div class="mt-4 flex gap-2">
      <a href="register.php?role=owner" class="px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800">Registrarme como dueño</a>
      <a href="login.php" class="px-4 py-2 rounded-xl border border-slate-200 hover:bg-slate-50">Ya tengo cuenta</a>
    </div>
  </div>
  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <div class="text-lg font-semibold">¿Buscás alquilar?</div>
    <p class="text-slate-600 mt-1">Encontrá autos cercanos, compará precios y reservá en minutos.</p>
    <div class="mt-4">
      <a href="search.php" class="px-4 py-2 rounded-xl border border-slate-200 hover:bg-slate-50 inline-block">Buscar autos</a>
    </div>
  </div>
</section>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
