<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/auth.php';
require_once __DIR__ . '/../app/csrf.php';

if (current_user()) redirect('index.php');

$rolePref = $_GET['role'] ?? 'user';
if (!in_array($rolePref, ['user','owner'], true)) $rolePref = 'user';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  csrf_verify();
  $name = trim($_POST['name'] ?? '');
  $email = strtolower(trim($_POST['email'] ?? ''));
  $phone = trim($_POST['phone'] ?? '');
  $role = ($_POST['role'] ?? 'user');
  $pass = (string)($_POST['password'] ?? '');

  if (!in_array($role, ['user','owner'], true)) $role = 'user';

  if ($name === '' || $email === '' || $pass === '') {
    flash_set('err', 'Completá nombre, email y contraseña.');
    redirect('register.php?role='.$role);
  }
  if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    flash_set('err', 'Email inválido.');
    redirect('register.php?role='.$role);
  }
  if (strlen($pass) < 8) {
    flash_set('err', 'La contraseña debe tener al menos 8 caracteres.');
    redirect('register.php?role='.$role);
  }

  $pdo = db();
  $hash = password_hash($pass, PASSWORD_DEFAULT);

  try {
    $stmt = $pdo->prepare('INSERT INTO users (role, name, email, phone, password_hash) VALUES (?,?,?,?,?)');
    $stmt->execute([$role, $name, $email, $phone, $hash]);
    $id = (int)$pdo->lastInsertId();

    $u = $pdo->prepare('SELECT * FROM users WHERE id=?');
    $u->execute([$id]);
    login_user($u->fetch());
    flash_set('ok', 'Cuenta creada. ¡Bienvenido!');
    redirect('index.php');
  } catch (PDOException $e) {
    if (str_contains($e->getMessage(), 'UNIQUE')) {
      flash_set('err', 'Ese email ya está registrado.');
      redirect('register.php?role='.$role);
    }
    throw $e;
  }
}

require_once __DIR__ . '/_layout_top.php';
?>
<div class="max-w-xl mx-auto">
  <div class="rounded-3xl border border-slate-200 bg-white p-6">
    <h2 class="text-2xl font-semibold">Crear cuenta</h2>
    <p class="text-slate-600 mt-1">Elegí tu rol: conductor (usuario) o dueño.</p>

    <form method="post" class="mt-6 space-y-4">
      <?= csrf_input() ?>
      <div>
        <label class="text-sm text-slate-600">Nombre</label>
        <input name="name" class="mt-1 w-full rounded-xl border-slate-200" required>
      </div>
      <div>
        <label class="text-sm text-slate-600">Email</label>
        <input name="email" type="email" class="mt-1 w-full rounded-xl border-slate-200" required>
      </div>
      <div>
        <label class="text-sm text-slate-600">Teléfono</label>
        <input name="phone" class="mt-1 w-full rounded-xl border-slate-200">
      </div>
      <div>
        <label class="text-sm text-slate-600">Rol</label>
        <select name="role" class="mt-1 w-full rounded-xl border-slate-200">
          <option value="user" <?= $rolePref==='user'?'selected':'' ?>>Conductor (usuario)</option>
          <option value="owner" <?= $rolePref==='owner'?'selected':'' ?>>Dueño (publica autos)</option>
        </select>
      </div>
      <div>
        <label class="text-sm text-slate-600">Contraseña</label>
        <input name="password" type="password" class="mt-1 w-full rounded-xl border-slate-200" minlength="8" required>
        <div class="text-xs text-slate-500 mt-1">Mínimo 8 caracteres.</div>
      </div>
      <button class="w-full rounded-xl bg-slate-900 text-white py-2.5 hover:bg-slate-800">Crear cuenta</button>
    </form>

    <div class="mt-4 text-sm text-slate-600">
      ¿Ya tenés cuenta? <a class="underline" href="login.php">Ingresar</a>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
