<?php
require_once __DIR__ . '/../app/db.php';
require_once __DIR__ . '/../app/availability.php';

$city = trim($_GET['city'] ?? '');
$start = trim($_GET['start'] ?? '');
$end = trim($_GET['end'] ?? '');
$min = (int)($_GET['min'] ?? 0);
$max = (int)($_GET['max'] ?? 0);

$pdo = db();

$sql = "SELECT c.*, u.name AS owner_name
        FROM cars c
        JOIN users u ON u.id = c.owner_id
        WHERE c.status='active'";
$params = [];

if ($city !== '') { $sql .= " AND lower(c.city) LIKE :city"; $params[':city'] = '%' . mb_strtolower($city) . '%'; }
if ($min > 0) { $sql .= " AND c.price_per_day >= :min"; $params[':min'] = $min; }
if ($max > 0) { $sql .= " AND c.price_per_day <= :max"; $params[':max'] = $max; }

$sql .= " ORDER BY c.created_at DESC LIMIT 50";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$cars = $stmt->fetchAll();

function cover_photo(int $carId): ?string {
  $pdo = db();
  $s = $pdo->prepare('SELECT path FROM car_photos WHERE car_id=? ORDER BY sort_order ASC, id ASC LIMIT 1');
  $s->execute([$carId]);
  $r = $s->fetch();
  return $r ? $r['path'] : null;
}

require_once __DIR__ . '/_layout_top.php';
?>
<div class="flex flex-col gap-4">
  <div class="rounded-3xl border border-slate-200 bg-white p-5">
    <form class="grid grid-cols-1 md:grid-cols-6 gap-3" method="get">
      <div class="md:col-span-2">
        <label class="text-xs text-slate-500">Ciudad</label>
        <input name="city" value="<?= e($city) ?>" placeholder="Ej: CABA" class="mt-1 w-full rounded-xl border-slate-200" />
      </div>
      <div>
        <label class="text-xs text-slate-500">Desde</label>
        <input type="date" name="start" value="<?= e($start) ?>" class="mt-1 w-full rounded-xl border-slate-200" />
      </div>
      <div>
        <label class="text-xs text-slate-500">Hasta</label>
        <input type="date" name="end" value="<?= e($end) ?>" class="mt-1 w-full rounded-xl border-slate-200" />
      </div>
      <div>
        <label class="text-xs text-slate-500">Min ARS</label>
        <input type="number" name="min" value="<?= e((string)$min) ?>" class="mt-1 w-full rounded-xl border-slate-200" />
      </div>
      <div>
        <label class="text-xs text-slate-500">Max ARS</label>
        <input type="number" name="max" value="<?= e((string)$max) ?>" class="mt-1 w-full rounded-xl border-slate-200" />
      </div>
      <div class="md:col-span-6 flex gap-2 items-center">
        <button class="px-4 py-2 rounded-xl bg-slate-900 text-white hover:bg-slate-800">Buscar</button>
        <span class="text-sm text-slate-500"><?= count($cars) ?> resultados</span>
      </div>
    </form>
  </div>

  <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
    <?php foreach ($cars as $c): 
      $cover = cover_photo((int)$c['id']);
      $isAvail = ($start && $end) ? car_is_available((int)$c['id'], $start, $end) : true;
    ?>
      <a href="car.php?id=<?= (int)$c['id'] ?>&start=<?= e($start) ?>&end=<?= e($end) ?>" class="group rounded-3xl border border-slate-200 bg-white overflow-hidden hover:shadow-md transition">
        <div class="aspect-[4/3] bg-slate-100 overflow-hidden">
          <?php if ($cover): ?>
            <img src="<?= e($cover) ?>" class="w-full h-full object-cover group-hover:scale-[1.02] transition">
          <?php else: ?>
            <div class="w-full h-full grid place-items-center text-slate-400 text-sm">Sin foto</div>
          <?php endif; ?>
        </div>
        <div class="p-4">
          <div class="flex items-center justify-between gap-2">
            <div class="font-semibold line-clamp-1"><?= e($c['title']) ?></div>
            <span class="text-xs px-2 py-1 rounded-full <?= $c['booking_mode']==='instant'?'bg-emerald-50 text-emerald-700':'bg-amber-50 text-amber-700' ?>">
              <?= $c['booking_mode']==='instant'?'Instant':'Aprobación' ?>
            </span>
          </div>
          <div class="text-sm text-slate-600 mt-1"><?= e($c['city'] ?? '') ?> · Punto fijo</div>
          <div class="mt-3 flex items-center justify-between">
            <div class="text-lg font-semibold"><?= money((int)$c['price_per_day']) ?><span class="text-sm text-slate-500 font-normal"> / día</span></div>
            <?php if ($start && $end): ?>
              <div class="text-xs <?= $isAvail?'text-emerald-700':'text-rose-700' ?>"><?= $isAvail?'Disponible':'No disponible' ?></div>
            <?php endif; ?>
          </div>
        </div>
      </a>
    <?php endforeach; ?>
  </div>
</div>
<?php require_once __DIR__ . '/_layout_bottom.php'; ?>
